function Za = approxZ(x,x00,relmin,p,s)
% Calulates Z by parameters x, X00 and p at s
% X00 are abosoulte parmeters 
% X are relative pamrametes
% p are known parametres
% relmin is minimum of x

  l=length(x);
  xmin = ones(1,l)*relmin;
  x=max(x,xmin);
  xx=x00.*x;
  
  if isempty(p)
    ncoils=(length(xx)-2)/2;
    R0 = xx(1);
    C0 = xx(2);
    for i=1:ncoils         
      Ls(i) = xx(2+i);
      Rs(i) = xx(2+ncoils+i);      
    end     
  else
    ncoils=(length(xx)-1)/2;
    R0 = p(1);
    C0 = xx(1);
    for i=1:ncoils         
      Ls(i) = xx(1+i);
      Rs(i) = xx(1+ncoils+i);      
    end     
  end  
  
  Zc=0;
  for i=1:ncoils
    Zsc = s*Ls(i)./ (1 + s*Ls(i)/Rs(i));
    Zc=Zc+Zsc;   
  end
  Zs=R0+Zc;
  Zp=1./(s*C0);
  Za=Zs.*Zp./(Zs+Zp);
  
end